%%% SURateSpikes version 4b
% Nicola Strenzke, 22.12.2017
% Using this routine, the result of the spike sorting is subjectively judged for the sorting quality.
% 0 means "redo spike sorting", 1 means every single spike seems correctly
% detected, 2 means almost every spike is correctly detected, only very few
% uncertain or missing spikes, 3 the big majority is correctly sorted, 4 no
% clear distinction between spikes and noise with "random" threshold, 5 absolutely no clear
% distinction, not useful, 6 unit was lost during the recording 7 two units
% recorded at the same time, 8 no spikes at all.
% the resulting graphs show the original trace, the original with spikes
% cut out, the detected spikes, and the candidates for spike detection
% which have been rejected because of spike waveform not matching the
% template.
% The graph on the right shows 20 sample traces throughout the run with
% spikes marked. The graph on the bottom shows the amplitude of detected
% spikes throughout the run. 
% The variables "User", "Animals", "Units", "SpikeRatings" and "TriggerReset allow to run both routines on selected datasets. 
% To be used exclusifely on data from auditory nerve single fiber
% recordings from the setup in Gttingen sorted using "SUfindSpikesFilter";
% contact NStrenzke@med.uni-goettingen.de if you want to adapt it to own
% data. 


clear all
close all
%path=['D:\SU\InAnalysis\'];
path=['D:\Data\SU\'];
%path=['C:\Documents and Settings\Nicola\My Documents\'];
%path=['Z:\systems\SU\Analyzed\'];
%path=['D:\Data\SU in analysis\'];


Animal = [  
 '0200'
 '0205' 
   ];

User='002';
%Animal = ['0018'];
Units= [1 200];
SpikeRatings=[0 1 2 3 4 5 6 7 8 9]   %all other previous spike ratings are skipped
SpikeRatings=[0]   %all other previous spike ratings are skipped
changeRating=[0 1]; %[0 1] for all runs or [1] for only those runs where the rating needs to be changed


%%% normally, no changes are neccessary beyond this point. 

crop=1.5e-3;TriggerRatio=2;
FontSize=12;
filter=[2000];
filterType='low'; % high or low (pass filter)
singlefilter=[400];
singlefilterType='high';


%FirstTrace=1;
%LastTrace=20;
MaxNoTraces=20;
ExpInfo.FreqRP2=24414


ScaleRMSHist=(-1:0.05:1);
for AnimalNo=1:size(Animal)
    path1=[path,num2str(User),'-',num2str(Animal(AnimalNo,:))]
    %gui.scrsz=get(0,'ScreenSize');
    clear ExpInfo SpikeDetectionZeros
    if size(dir([path1,'\','ExpInfo ',path1((size(path1,2)-7):size(path1,2)),'.mat']),1)==1
        load([path1,'\','ExpInfo ',path1((size(path1,2)-7):size(path1,2))])
    else
        Message = 'no ExpInfo-File'
    end
    if exist('SpikeDetectionZeros')==0;SpikeDetectionZeros=1000;end
    SpikeDetectionZeros
    isNotEnde=1;
    while isNotEnde==1 %& SpikeDetectionZeros>0;
        for currentUnit=Units(1):Units(2);
            if isNotEnde==0
                break
            end

            close all
            UnitFiles=[num2str(User),'-',num2str(Animal(AnimalNo,:)),'-',num2str(currentUnit),'-','*.jpg'];
            files=dir(fullfile(path1,'\',UnitFiles));
            if size(files,1)==0
                Message = ['no files for Unit ',Animal(AnimalNo,:),' - ',num2str(currentUnit)]
            else
                for filenumber=1:size(files,1)
                    if isNotEnde==0 break;  end
                    files(filenumber).name;
                    clear SpikeRating NewRating Spikes RunInfo SUDatSave AP Data Data1 Data2 TraceNo

                    load([path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))],'SpikeRating','RunInfo','AP','SUDatSave')
                    if exist('SpikeRating') == 0
                        NewRating=0;SpikeRating=0;RunInfo.changeRating==1
                    else
                        if SpikeRating >=0 & SpikeRating <=8
                            NewRating=SpikeRating;
                        else NewRating =0;
                        end
                    end

                    if ismember(SpikeRating,SpikeRatings)==1 & ismember(RunInfo.changeRating,changeRating)==1;
                        jpgpicture=imread(fullfile(path1,files(filenumber).name));
                        if isfield(RunInfo,'changeRating')==0;RunInfo.changeRating=1;end

                        interface = figure('color','w'); set (interface,'name',fullfile(path1,files(filenumber).name),'Units','normalized','Position',[0.05,0.1,0.9,0.9],'toolbar','figure');
                        text1 = uicontrol(interface, 'style','text', 'Units','normalized','Position',[0.1,0.1,0.3,0.03]);
                        set(text1,'string',['previous spike rating: ',num2str(SpikeRating)],'BackgroundColor','w','FontSize',FontSize);
                        RunInfo.changeRating=0;
                        menu = uicontrol(interface,'style','popupmenu','FontSize',FontSize,'Units','normalized','Position',[0.4,0.1,0.15,0.05]);
                        set(menu, 'String', {'0 redo','1 excellent','2 good','3 fair','4 poor','5 failed','6 lost','7 two fibers','8 no spikes'});
                        set(menu,'Value',NewRating+1);changed=0;
                        set(menu,'Callback','NewRating=get(menu,''Value'')-1;changed=1;RunInfo.changeRating=0;');

                        update = uicontrol (interface,'style','pushbutton','Units','normalized','FontSize',FontSize,'Position',[0.6,0.1,0.15,0.05]);
                        set(update,'string','update');
                        set(update,'Callback','SpikeRating=NewRating;close gcf,uiresume');

                        EndProgram = uicontrol (interface,'style','pushbutton','Units','normalized','FontSize',FontSize,'Position',[0.8,0.1,0.15,0.05]);
                        set(EndProgram,'string','end');
                        set(EndProgram,'Callback','isNotEnde=0;close all;return; uiresume');

                        text1 = uicontrol(interface, 'style','text', 'Units','normalized','Position',[0.15,0.05,0.3,0.03]);
                        set(text1,'string',['RunType: ',RunInfo.RunType],'BackgroundColor','w','FontSize',FontSize);
                        if isfield(AP,'SpikeAmpPos')
                            a=abs(AP.SpikeAmpPos)+abs(AP.SpikeAmpNeg);
                            kk=1;
                            for ii=1:size(a,2)
                                for jj=1:size(a,1)
                                    Spikes(kk)=a(jj,ii);
                                    kk=kk+1;
                                end
                            end;clear ii jj kk

                            PlotSpikes=subplot(2,1,2);
                            plot(Spikes)
                            axis off
                            set (PlotSpikes,'Units','normalized','FontSize',FontSize,'Position',[0.05,0.16,0.9,0.1]);
                        end



                        
                        nLastTrace=MaxNoTraces;
                        clear step1 step2
                        if size(SUDatSave,2)<=nLastTrace;% if there are fewer traces, only these are plotted
                            nLastTrace=size(SUDatSave,2);
                            Data1=double(SUDatSave);
                            step2=(1:1:nLastTrace);
                        elseif size(SUDatSave,2)>nLastTrace %if there are more traces, the last trace will be the last trace of the recording
                            step=floor(size(SUDatSave,2)/MaxNoTraces);
                            Data1(:,1)=double(SUDatSave(:,1));
                            step1=step;
                            step2=1;
                            for ii=2:MaxNoTraces;
                                Data1(:,ii)=double(SUDatSave(:,step1));
                                step2(ii)=step1;
                                step1=step1+step;
                            end
                            
                            %Data1(nLastTrace,:)=Data1(size(Data1,2),:);
                        end

                        %%% filtering
                        if strcmp(RunInfo.RunType(1:2),'PS')==1 | strcmp(RunInfo.RunType(1:2),'FM')==1; MaxStim=RunInfo.StimAmp;
                        elseif strcmp(RunInfo.RunType(1:2),'RL')==1; MaxStim=max(RunInfo.Levels(1,:));RunInfo.StimFreq=RunInfo.Frequency;
                        else MaxStim=0;
                        end
                        for n=1:nLastTrace %%% filter
                            [b,a]=butter(2, singlefilter/(ExpInfo.FreqRP2/2) ,singlefilterType);
                            Data(:,n)=filtfilt(b,a,Data1(:,n));
                            [b,a]=butter(2, filter/(ExpInfo.FreqRP2/2) ,filterType);
                            Data(:,n)=filtfilt(b,a,Data(:,n));
                            RunInfo.Filters=[singlefilter filter 0];
                            %if (strcmp(RunInfo.RunType(1:2),'PS')==1 | strcmp(RunInfo.RunType(1:2),'RL')==1)
                            %%% for high levels of frequencies below 12kHz filter out stimulus artifact
                            if strcmp(RunInfo.RunType(1:2),'PS')==1 | strcmp(RunInfo.RunType(1:2),'FM')==1; MaxStim=RunInfo.StimAmp;
                            elseif strcmp(RunInfo.RunType(1:2),'RL')==1; MaxStim=max(RunInfo.Levels(1,:));RunInfo.StimFreq=RunInfo.Frequency;
                            else MaxStim=0;
                            end
                            if strcmp(RunInfo.RunType(1:2),'RE')==1 & n<size(Data1,2)-1
                                if isfield (RunInfo,'StimAmp')==1;RunInfo.StimFreq=RunInfo.Frequency(n);MaxStim=RunInfo.StimAmp(n);else MaxStim=90; end
                            end
                            if strcmp(RunInfo.RunType(1:2),'TC')==1;
                                MaxStim=RunInfo.TCDatSave(2,n); RunInfo.StimFreq=RunInfo.TCDatSave(1,n);
                            end
                            if  strcmp(RunInfo.Stimulus(1:2),'Si')==1 & MaxStim>90 & RunInfo.StimFreq<=10000;
                                if RunInfo.StimFreq<160
                                    [b,a]=butter(2, [(RunInfo.StimFreq-90)/(ExpInfo.FreqRP2/2) (RunInfo.StimFreq+90)/(ExpInfo.FreqRP2/2)] ,'stop');
                                else
                                    [b,a]=butter(2, [(RunInfo.StimFreq-150)/(ExpInfo.FreqRP2/2) (RunInfo.StimFreq+150)/(ExpInfo.FreqRP2/2)] ,'stop');
                                end
                                Data(:,n)=filtfilt(b,a,Data(:,n));
                                RunInfo.Filters(3)=RunInfo.StimFreq;
                            end
                        end

                        %%% scale data and add 0.001 to each trace so they are plotted one above each other
                        a=RunInfo.RunType;
                        Data2=[];
                        if isfield(AP,'SpikeTimes')==0; AP.SpikeTimes(1:nLastTrace)=0;end
                        AP.SpikeTimes=AP.SpikeTimes/ExpInfo.FreqRP2*1000;
                        for ii=1:nLastTrace
                            Data2(:,ii)=Data(:,ii)+(0.001*(ii-1))+0.001;
                        end

                        for ii=1:size(AP.SpikeTimes,2)
                            SpikeNo(ii)=size(find(AP.SpikeTimes(:,ii)<53),1)-size(find(AP.SpikeTimes(:,ii)<3),1);
                        end
                        Data2=Data2*1000;

                        %%% plot filtered traces
                        time=(4.0960e-002: 4.0960e-002:10000)';
                        %MainFigure=figure('name',Filename,'Units','normalized','Position',[0.01,0.1,0.8,0.85]);% Position [left bottom width height]
                        PlotTraces=subplot(2,5,5);
                        set (PlotTraces,'Units','normalized','FontSize',FontSize,'Position',[0.75,0.3,0.22,0.6]);
                        plot(time(1:size(Data1,1)),Data2(:,1:nLastTrace),'k')
                        hold on
                        for ii=1:nLastTrace
                            TraceNo(1:size(AP.SpikeTimes,1))=((0.001*(ii-1))+0.001)*1000;
                            if size(AP.SpikeTimes,2)<step2(ii);AP.SpikeTimes(:,step2(ii))=0;end
                      
                            plot(AP.SpikeTimes(:,step2(ii)),TraceNo,'or')
                        end
                        if isfield(RunInfo,'RecDur')==0; RunInfo.RecDur=100;end    
                        axis ([0 RunInfo.RecDur 0 nLastTrace+1])
                        xlabel ('time re stimulus onset (ms)','FontWeight','bold','FontName','Arial','FontSize',10)
                        %ylabel ('repeat number','FontWeight','bold','FontName','Arial','FontSize',10)
                        box off

                        PlotImage=subplot(2,5,1:4);
                        iptsetpref('ImshowAxesVisible','off')
                        imshow(jpgpicture)
                        set (PlotImage,'Units','normalized','FontSize',FontSize,'Position',[0.01,0.3,0.7,0.7]);
                        uiwait

                        save([path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))],'SpikeRating','RunInfo','-APPEND')
                        message = ['file ',[path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))],' saved, spike rating ',num2str(SpikeRating)]

                        if SpikeRating==0
                            %load([path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))])
                            %Data=double(SUDatSave); clear SUDatSave
                            %if strcmp(RunInfo.RunType(1:2),'RL')==1&&isfield(RunInfo,'Frequency')==0;RunInfo.Frequency=200;end;
                            %if strcmp(RunInfo.RunType(1:2),'PS')==1; MaxStim=RunInfo.StimAmp;
                            %elseif strcmp(RunInfo.RunType(1:2),'FM')==1; MaxStim=RunInfo.StimAmp;
                            %elseif strcmp(RunInfo.RunType(1:2),'RL')==1; MaxStim=max(RunInfo.Levels(1,:));RunInfo.StimFreq=RunInfo.Frequency;
                            %else MaxStim=0;end
                            %if  strcmp(RunInfo.Stimulus(1:3),'Sin')==1 & MaxStim>90 & RunInfo.StimFreq<=10000
                            %    for n=1:size(Data,2)
                            %        %tic
                            %        [b,a]=butter(2, [(RunInfo.StimFreq-150)/(ExpInfo.FreqRP2/2) (RunInfo.StimFreq+150)/(ExpInfo.FreqRP2/2)] ,'stop');
                            %        Data(:,n)=filtfilt(b,a,Data(:,n));
                            %        %toc
                            %    end
                            %end
                            %Data1=Data;

                            if isfield (RunInfo,'Trigger')
                                TriggerLevel(1:size(Data1,1))=RunInfo.Trigger;
                            else TriggerLevel(1:size(Data1,1))=1e-4;
                            end
                            %main figure
                            interface2=figure('color','w','Units','normalized','Position',[0.1,0.07,0.7,0.9]);
                            set (interface2,'name',[path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))]);
                            Data2=reshape(Data1,1,size(Data1,1)*size(Data1,2));
                            HistPlot=subplot(4,4,5);
                            set (HistPlot,'Units','normalized','FontSize',FontSize,'Position',[0.2,0.2,0.4,0.2]);
                            a=hist(Data2,100);[maximum maxpos]=max(a);
                            hist(Data2,50,'r-x');
                            %plot(a);
                            %axis ([0 inf 0 (max(a)/1)]);%axis off;
                            set(gca,'YScale','log')
                            hold on; grid on
                            TriggerPlotHist=plot(TriggerLevel,1:size(TriggerLevel,2),'r-','MarkerSize',15);
                            TriggerPlotHist1=plot(TriggerLevel/TriggerRatio,1:size(TriggerLevel,2),'r:','MarkerSize',10);
                            hold off

                            if isfield(RunInfo,'SpikeRMShist')==1
                                SpikeFormHistPlot=subplot(4,4,16);
                                set (SpikeFormHistPlot,'Units','normalized','FontSize',FontSize,'Position',[0.7,0.2,0.25,0.2]);
                                plot(ScaleRMSHist,RunInfo.SpikeRMShist);title('RMS dist. spike candidates');
                            end

                            DataPlot=subplot(4,4,1:8);
                            set (DataPlot,'Units','normalized','FontSize',FontSize,'Position',[0.2,0.5,0.7,0.4]);
                            %Data1Plot=
                            plot(Data1);
                            hold on
                            plot(TriggerLevel,'k')
                            TriggerPlot1=plot(TriggerLevel/TriggerRatio,':r');
                            TriggerPlot=plot(TriggerLevel,'r');
                            xlabel('data points','FontSize',FontSize);ylabel('amplitude (V)','FontSize',FontSize);
                            hold off



                            %button 'crop'
                            cropui = uicontrol (interface2,'style','pushbutton','string',['crop ',num2str(crop)],'Units','normalized','FontSize',FontSize,'Position',[0.1,0.1,0.15,0.05]);
                            set(cropui,'Callback','for ii=1:size(Data1,1);for jj=1:size(Data1,2); if Data1(ii,jj)>crop Data1(ii,jj)=crop;RunInfo.croppped=crop;elseif Data1(ii,jj)<-crop Data1(ii,jj)=-crop;RunInfo.cropped=-crop;end;end;end; Data1Plot=plot(Data1);hold on;plot(TriggerLevel,''k'');TriggerPlot=plot(TriggerLevel,''r'');TriggerPlot1=plot(TriggerLevel/TriggerRatio),'':r'';hold off;');

                            %button 'invert'
                            invert = uicontrol (interface2,'style','pushbutton','string','invert','Units','normalized','FontSize',FontSize,'Position',[0.4,0.05,0.15,0.05]);
                            set(invert,'Callback','Data1=-1*Data1;RunInfo.TriggerReset=1; if RunInfo.invertTrace==1; RunInfo.invertTrace=0; else RunInfo.invertTrace=1;end; Data1Plot=plot(Data1);hold on;plot(TriggerLevel,''k'');TriggerPlot=plot(TriggerLevel,''r'');TriggerPlot1=plot(TriggerLevel/TriggerRatio),'':r'';hold off;');

                            %button 'update'
                            update = uicontrol (interface2,'style','pushbutton','string','update','Units','normalized','FontSize',FontSize,'Position',[0.6,0.05,0.15,0.05]);
                            set(update,'Callback','NewTriggerLevel=get(uiSpikeThreshold,''Value'');close all;uiresume');

                            %button 'end program', aborts running loops to quit
                            EndProgram = uicontrol (interface2,'style','pushbutton','string','end','Units','normalized','FontSize',FontSize,'Position',[0.8,0.05,0.15,0.05]);
                            set(EndProgram,'Callback','isEnde=1;close all;return;uiresume');

                            %slider to change Trigger Level and text with current value
                            %uiSpikeThreshold =uicontrol('Style','slider','Units','normalized','FontSize',12,'Position',[0.05,0.05,0.02,0.8],'Min',2*1e-5,'Max',3e-3,'Value',TriggerLevel(1,1),'Callback','RunInfo.TriggerReset=1;TriggerLevel(1:size(TriggerLevel,2))=get(uiSpikeThreshold,''Value''),set(uiSpikeThresholdText,''String'',num2str(TriggerLevel));set(TriggerPlot,''YData'',TriggerLevel);set(TriggerPlot1,''YData'',TriggerLevel/TriggerRatio)');
                            uiSpikeThreshold =uicontrol(interface2,'Style','slider','Units','normalized','FontSize',12,'Position',[0.05,0.05,0.02,0.8],'Min',2*1e-5,'Max',3e-3,'Value',TriggerLevel(1,1),'Callback','RunInfo.TriggerReset=1;TriggerLevel(1:size(TriggerLevel,2))=get(uiSpikeThreshold,''Value'');set(uiSpikeThresholdText,''String'',num2str(TriggerLevel(1)));set(TriggerPlot,''YData'',TriggerLevel);set(TriggerPlot1,''YData'',TriggerLevel/TriggerRatio);set(TriggerPlotHist,''XData'',TriggerLevel);set(TriggerPlotHist1,''XData'',TriggerLevel/TriggerRatio);');
                            uiSpikeThresholdText=uicontrol(interface2,'Style','Text','String',num2str(TriggerLevel(1,1)),'Units','normalized','Position',[0.05 0.86 0.1 0.03],'FontSize',FontSize,'BackgroundColor','w');

                            %checkbox if triggering is poor e.g. due to stimulus artifacts
                            if isfield(RunInfo,'UseStandardWaveform')==0
                                RunInfo.UseStandardWaveform=0;
                            end
                            check = uicontrol ('style','checkbox','Units','normalized','Position',[0.1,0.04,0.3,0.05]);
                            set(check,'string','use Standard Waveform','value',RunInfo.UseStandardWaveform,'BackgroundColor','w','FontSize',FontSize);
                            set(check,'Callback','RunInfo.TriggerReset=1;RunInfo.UseStandardWaveform = get(check,''value'');')

                            uiwait(interface2) % wait for buttons update or end program to be pushed

                            %if exist('NewTriggerLevel')==1 % if button 'update has been pushed, get new SpikeTimesQuick and save
                            clear SpikeTimesQuick
                            for n=1:size(Data1,2)
                                [Spike]=SUFindSpikeQuick2(Data1(:,n),NewTriggerLevel);
                                Spike=Spike'/ExpInfo.FreqRP2*1000;%make SpikeTimesQuick contain data in ms format in columns
                                SpikeTimesQuick(1:size(Spike,1),n)=Spike; clear Spike
                            end
                            %SUDatSave=single(Data1);
                            RunInfo.Trigger=NewTriggerLevel;
                            RunInfo.TriggerReset=1;
                            RunInfo.TriggerResetDate=datestr(now); %TimeStamp of Modification
                            save([path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))],'SpikeTimesQuick','RunInfo','-APPEND')
                            message = ['file ',[path1,'\',files(filenumber).name(1:(size(files(filenumber).name,2)-4))],' saved, trigger level  ',num2str(RunInfo.Trigger)]
                            clear Data1 RunInfo NewTriggerLevel SpikeTimesQuick TriggerLevel SUDatSave
                            close all
                        end
                    else
                        close gcf
                    end
                end
            end
            if currentUnit==Units(2); isNotEnde=0; end
        end
    end
end
%sound( sin( 660*(2*pi*(0:(0.5*22050))/22050) ), 22050)
close gcf